on run(argv)
    -- 参数检查
    if (count of argv) = 0 then
        error "未提供参数"
    end if
    set appPath to item 1 of argv

    -- 检查路径是否以.app结尾
    if appPath does not end with ".app" then
        error "提供的路径不是一个.app应用程序: " & appPath
    end if
    
    -- 获取应用程序名称（不带.app后缀）
    set {tid, AppleScript's text item delimiters} to {AppleScript's text item delimiters, "/"}
    set pathComponents to text items of appPath
    set AppleScript's text item delimiters to tid
    set appName to last item of pathComponents
    set appName to text 1 thru ((length of appName) - 4) of appName -- 去掉.app后缀

    -- 找进程
    set startTime to current date
    tell application "System Events"
        set isFound to false
        repeat while (current date) - startTime < 10
            if exists process appName then
                set isFound to true
                exit repeat
            end if
            delay 0.1
        end repeat

        if not isFound then
            return "process not found"
        end if 

        -- 等待安装程序结束
        repeat
            try
                if not exists process appName then
                    exit repeat
                end if
            on error
                delay 0.1
            end try
        end repeat
    end tell
    
    set appName to "unknown"

    -- 识别应用类型
    if appPath contains "iopro" then
        set appName to "iO Pro"
    else if appPath contains "io" then
        set appName to "iO"
    else if appPath contains "pd4" then
        set appName to "ProDriver"
    end if

    -- 检查应用是否已安装
    set targetAppPath to "/Applications/" & appName & ".app"
    tell application "System Events"
        if exists file targetAppPath then
            set dialogResult to display dialog appName & " is ready! Launch it?" buttons {"Yes", "No"} default button "Yes"
            if button returned of dialogResult is "Yes" then
                do shell script "open " & quoted form of targetAppPath
            end if
            return "app found"
        else
            return "app not found:" & appName
        end if
    end tell
end run
